/*
 * Decompiled with CFR 0.152.
 */
package de.skatcom.skatupdater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Updater {
    public static final Map<String, String> TEXTE = new HashMap<String, String>();
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String TMP_FOLDER = "tmp" + System.currentTimeMillis();
    private static final String VERSION_URL = "http://download.skat-online.com/installer/version";
    private static final String WHATSNEW_URL = "http://download.skat-online.com/installer/whatsnew";
    private static final String FILELIST_URL = "http://download.skat-online.com/installer/filelist";
    private static final String JARS_URL = "http://download.skat-online.com/installer/jars";
    private static String latestVersion;
    private static String whatsNew;
    private static List<String> fileList;

    static {
        TEXTE.put("INSTALL_DE", "installieren");
        TEXTE.put("INSTALL_PL", "zainstalowa\u0107");
        TEXTE.put("INSTALL_ES", "instale");
        TEXTE.put("INSTALL_EN", "install");
        TEXTE.put("ERROR_DE", "Bei der Installation des Updates ist ein Fehler aufgetreten.\n\nWende Dich bitte an den Support, wenn der Fehler bestehen bleibt.\n\nSoll die Installation wiederholt werden?");
        TEXTE.put("ERROR_PL", "Wyst\u0105pi\u0142 b\u0142\u0105d podczas instalowania aktualizacji.\nprosz\u0119 Je\u015bli b\u0142\u0105d b\u0119dzie si\u0119 powtarza\u0142, skontaktuj si\u0119 z pomoc\u0105 Skat-online.\n\nInstalacja powinna by\u0107 powt\u00f3rzony?");
        TEXTE.put("ERROR_ES", "Se produjo un error durante la instalaci\u00f3n de la actualizaci\u00f3n.\nPor favor, si el error persiste, p\u00f3ngase en contacto con el Soporte Skat-Online.\n\nSe debe repetir la instalaci\u00f3n?");
        TEXTE.put("ERROR_EN", "There was an error installing the update. \nIf the error persists, please contact Skat-Online Support.\n\nRetry installation?");
        TEXTE.put("ERRTITLE_DE", "Fehler");
        TEXTE.put("ERRTITLE_PL", "b\u0142\u0105d");
        TEXTE.put("ERRTITLE_ES", "error");
        TEXTE.put("ERRTITLE_EN", "Error");
        TEXTE.put("CANCEL_DE", "abbrechen");
        TEXTE.put("CANCEL_PL", "przerwa\u0107");
        TEXTE.put("CANCEL_ES", "abortar");
        TEXTE.put("CANCEL_EN", "cancel");
        TEXTE.put("INFO_DE", "Ein Skat-Online Update ist verf\u00fcgbar. Version: ");
        TEXTE.put("INFO_PL", "Aktualizacja Skat-Online jest dost\u0119pna. Wersja: ");
        TEXTE.put("INFO_ES", "Una actualizaci\u00f3n de Skat-Online est\u00e1 disponible. Versi\u00f3n: ");
        TEXTE.put("INFO_EN", "A Skat-Online update is available. Version: ");
        latestVersion = null;
        whatsNew = null;
        fileList = null;
    }

    public static String getLatestVersion() throws IOException {
        if (latestVersion == null) {
            latestVersion = Updater.getData(VERSION_URL);
        }
        return latestVersion;
    }

    public static String getWhatsNew() throws IOException {
        if (whatsNew == null) {
            whatsNew = Updater.getData(WHATSNEW_URL);
        }
        return whatsNew;
    }

    public static List<String> getFileList() throws IOException {
        if (fileList == null) {
            fileList = Arrays.asList(Updater.getData(FILELIST_URL).split("\n"));
        }
        return fileList;
    }

    public static String getFileData(String file) throws IOException {
        return Updater.getData("http://download.skat-online.com/installer/jars/" + file);
    }

    public static void downloadFile(String filename, File downloadFolder) throws IOException {
        URL downloadUrl = new URL("http://download.skat-online.com/installer/jars/" + filename);
        Files.copy(downloadUrl.openStream(), new File(downloadFolder, filename).toPath(), new CopyOption[0]);
    }

    public static void copyFile(String filename, File workingFolder) throws IOException {
        File progFolder = Updater.getProgramFolder();
        if (!progFolder.exists()) {
            progFolder.mkdirs();
        }
        Path source = new File(workingFolder, filename).toPath();
        Path target = new File(Updater.getProgramFolder(), filename).toPath();
        Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public static long getSize(String address) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL downloadUrl = new URL("http://download.skat-online.com/installer/jars/" + address);
            conn = (HttpURLConnection)downloadUrl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            long l = conn.getContentLength();
            return l;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String getData(String address) throws IOException {
        String inputLine;
        URL url = new URL(address);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "ISO-8859-1"));
        StringBuffer buffer = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            buffer.append(inputLine).append('\n');
        }
        in.close();
        return buffer.toString().trim();
    }

    private static String getData(File file) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer buffer = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            buffer.append(inputLine);
        }
        in.close();
        return buffer.toString().trim();
    }

    public static final String getActVersion() throws IOException {
        File aktVersion = new File(Updater.getProgramFolder(), "version");
        if (aktVersion.exists()) {
            return Updater.getData(aktVersion);
        }
        return null;
    }

    public static final File getProgramFolder() {
        return new File(Updater.getMainFolder(), "jars");
    }

    public static final File getMainFolder() {
        return new File(USER_DIR, "skatonline");
    }

    public static final File getTempFolder() throws IOException {
        File temp = new File(Updater.getMainFolder(), TMP_FOLDER);
        if (!temp.exists()) {
            temp.mkdirs();
        }
        return temp;
    }

    public static final void cleanTempFolder() throws IOException {
        File temp = new File(Updater.getMainFolder(), TMP_FOLDER);
        if (temp.exists()) {
            File[] fileArray = temp.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
        temp.deleteOnExit();
    }

    private static byte[] createChecksum(File file) throws NoSuchAlgorithmException, IOException {
        int numRead;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static final String getChecksum(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try {
            byte[] b = Updater.createChecksum(file);
            String result = "";
            int i = 0;
            while (i < b.length) {
                result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
                ++i;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static void runProgram(String[] params) throws IOException {
        try {
            URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            List<String> fileList = Updater.getFileList();
            for (String file : fileList) {
                URL url = new File(Updater.getProgramFolder(), file).toURI().toURL();
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, url);
            }
            Class<?> mainClass = Class.forName("de.skatcom.skatonline.gui.SkatOnline", true, classLoader);
            Class[] args = new Class[]{String[].class};
            System.setProperty("skatonline.dir", Updater.getMainFolder().getAbsolutePath());
            Method startMethod = mainClass.getDeclaredMethod("main", args);
            startMethod.invoke(null, new Object[]{params});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static void main(String[] args) {
        try {
            File base = new File("C:/Users/Markus Riehl/workspace/Skat-Online/dist/lib");
            File[] fileArray = base.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                System.out.print(String.valueOf(f.getName()) + ": ");
                System.out.println(Updater.getChecksum(f));
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

