/*
 * Decompiled with CFR 0.152.
 */
package de.skatcom.skatupdater;

import de.skatcom.skatupdater.UpdateDialog;
import de.skatcom.skatupdater.Updater;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class UpdateMain {
    private static UpdateDialog updateDialog;

    public static void secondaryMain(String[] margs) {
        if (margs != null && margs.length > 0) {
            try {
                URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<?> mainClass = Class.forName("de.skatcom.skatonline.gui.SkatOnline", true, classLoader);
                Class[] args = new Class[]{String[].class};
                Method startMethod = mainClass.getDeclaredMethod("secondaryMain", args);
                startMethod.invoke(null, new Object[]{margs});
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            File propDir;
            File logDir;
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            File userDir = Updater.getMainFolder();
            if (!userDir.exists()) {
                userDir.mkdirs();
            }
            if (!(logDir = new File(userDir, "logs")).exists()) {
                logDir.mkdir();
            }
            if (logDir.exists()) {
                System.setOut(new PrintStream(new File(logDir, "out.log")));
                System.setErr(new PrintStream(new File(logDir, "err.log")));
            }
            if (!(propDir = new File(userDir, "props")).exists()) {
                propDir.mkdir();
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String lang = "DE";
        try {
            String osLocal = Locale.getDefault().getCountry().toUpperCase();
            if ("EN".equals(osLocal) || "PL".equals(osLocal) || "ES".equals(osLocal)) {
                lang = osLocal;
            }
            String version = Updater.getLatestVersion();
            String aktVersion = Updater.getActVersion();
            if (aktVersion == null || !aktVersion.equals(version)) {
                String whatsnew = Updater.getWhatsNew();
                updateDialog = new UpdateDialog(lang, whatsnew, version, args);
                updateDialog.setVisible(true);
            } else {
                SplashScreen sp = SplashScreen.getSplashScreen();
                if (sp != null) {
                    sp.close();
                }
                Updater.runProgram(args);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(updateDialog, String.valueOf(Updater.TEXTE.get("ERROR_" + lang)) + "\n\n" + Updater.getStackTrace(e), Updater.TEXTE.get("ERRTITLE_" + lang), 0);
            System.exit(-1);
        }
    }
}

