/*
 * Decompiled with CFR 0.152.
 */
package de.skatcom.skatupdater;

import de.skatcom.skatupdater.ComboBoxRenderer;
import de.skatcom.skatupdater.DownloadDialog;
import de.skatcom.skatupdater.Updater;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class UpdateDialog
extends JFrame {
    private static final long serialVersionUID = -3346845115283024562L;
    private JPanel contentPane;
    private String language;
    private JLabel infoLabel;
    private static final String[] LANGUAGE = new String[]{"DE", "EN", "PL", "ES"};
    private static final Color BACKGROUND_COLOR = new Color(11, 72, 107);
    private static final Color SELECTED_COLOR = new Color(1, 132, 132);
    private long updateSize = 0L;
    private JButton installButton;

    public UpdateDialog(String lang, String whatsnew, final String version, final String[] args) {
        new Thread(){

            @Override
            public void run() {
                try {
                    UpdateDialog.this.updateSize = UpdateDialog.this.getFileSize();
                    if (UpdateDialog.this.installButton != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UpdateDialog.this.updateOkButtonText();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        this.setDefaultCloseOperation(3);
        this.setSize(550, 650);
        this.setUndecorated(true);
        try {
            ArrayList<Image> icons = new ArrayList<Image>(6);
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title16.png")).getImage());
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title32.png")).getImage());
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title48.png")).getImage());
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title64.png")).getImage());
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title128.png")).getImage());
            icons.add(new ImageIcon(UpdateDialog.class.getResource("title256.png")).getImage());
            this.setIconImages(icons);
        }
        catch (Throwable e) {
            this.setIconImage(new ImageIcon(UpdateDialog.class.getResource("title32.png")).getImage());
        }
        this.centerDialog();
        this.language = lang;
        this.contentPane = new JPanel();
        this.contentPane.setBackground(BACKGROUND_COLOR);
        this.contentPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setPreferredSize(new Dimension(550, 150));
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.white));
        this.contentPane.add((Component)buttonPanel, "South");
        final JPanel installButtonPanel = new JPanel();
        installButtonPanel.setBackground(BACKGROUND_COLOR);
        installButtonPanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.installButton = new JButton(Updater.TEXTE.get("INSTALL_" + lang));
        this.installButton.setVerticalTextPosition(3);
        this.installButton.setHorizontalTextPosition(0);
        this.installButton.setIcon(new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/install.png")));
        this.installButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                installButtonPanel.setBackground(SELECTED_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                installButtonPanel.setBackground(BACKGROUND_COLOR);
            }
        });
        this.installButton.setFont(this.installButton.getFont().deriveFont(this.installButton.getFont().getStyle() | 1, 20.0f));
        this.installButton.setContentAreaFilled(false);
        this.installButton.setBorderPainted(false);
        this.installButton.setForeground(Color.WHITE);
        this.installButton.setOpaque(false);
        this.installButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateDialog.this.update(args);
            }
        });
        buttonPanel.setLayout(new GridLayout(0, 2, 0, 0));
        installButtonPanel.add(this.installButton);
        buttonPanel.add(installButtonPanel);
        final JPanel cancelButtonPanel = new JPanel();
        cancelButtonPanel.setBackground(BACKGROUND_COLOR);
        cancelButtonPanel.setLayout(new GridLayout(0, 1, 0, 0));
        final JButton cancelButton = new JButton(Updater.TEXTE.get("CANCEL_" + lang));
        cancelButton.setHorizontalTextPosition(0);
        cancelButton.setVerticalTextPosition(3);
        cancelButton.setIcon(new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/exit.png")));
        cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                cancelButtonPanel.setBackground(SELECTED_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                cancelButtonPanel.setBackground(BACKGROUND_COLOR);
            }
        });
        cancelButton.setBorder(new MatteBorder(0, 1, 0, 0, new Color(255, 255, 255)));
        cancelButton.setCursor(Cursor.getPredefinedCursor(12));
        cancelButton.setContentAreaFilled(false);
        cancelButton.setFont(cancelButton.getFont().deriveFont(cancelButton.getFont().getStyle() | 1, 20.0f));
        cancelButton.setForeground(Color.WHITE);
        cancelButton.setOpaque(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        cancelButtonPanel.add(cancelButton);
        buttonPanel.add(cancelButtonPanel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(BACKGROUND_COLOR);
        this.contentPane.add((Component)scrollPane, "Center");
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setText(whatsnew);
        editorPane.scrollToReference(lang);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        editorPane.setBorder(null);
        editorPane.setEditable(false);
        scrollPane.setViewportView(editorPane);
        JPanel headerPanel = new JPanel();
        headerPanel.setBorder(new MatteBorder(0, 0, 1, 0, new Color(255, 255, 255)));
        headerPanel.setOpaque(false);
        this.contentPane.add((Component)headerPanel, "North");
        headerPanel.setLayout(new BorderLayout(0, 0));
        JLabel headerLabel = new JLabel("");
        headerPanel.add((Component)headerLabel, "North");
        headerLabel.setHorizontalAlignment(0);
        headerLabel.setBackground(new Color(232, 232, 232));
        headerLabel.setOpaque(true);
        headerLabel.setIcon(new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/skat-online-logo.png")));
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        infoPanel.setOpaque(false);
        headerPanel.add((Component)infoPanel, "South");
        infoPanel.setLayout(new BorderLayout(5, 0));
        final JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.setOpaque(false);
        comboBox.setRenderer(new ComboBoxRenderer());
        comboBox.addItem(new JLabel("Deutsch", new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/de.png")), 2));
        comboBox.addItem(new JLabel("English", new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/en.png")), 2));
        comboBox.addItem(new JLabel("Polnish", new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/pl.png")), 2));
        comboBox.addItem(new JLabel("Espa\u00f1ol", new ImageIcon(UpdateDialog.class.getResource("/de/skatcom/skatupdater/es.png")), 2));
        int i = 0;
        while (i < LANGUAGE.length) {
            if (lang != null && lang.equals(LANGUAGE[i])) {
                comboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        infoPanel.add(comboBox, "West");
        this.infoLabel = new JLabel(String.valueOf(Updater.TEXTE.get("INFO_" + lang)) + version);
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(this.infoLabel.getFont().getStyle() | 1, 14.0f));
        this.infoLabel.setForeground(new Color(255, 255, 255));
        infoPanel.add((Component)this.infoLabel, "Center");
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                UpdateDialog.this.language = LANGUAGE[comboBox.getSelectedIndex()];
                editorPane.scrollToReference(UpdateDialog.this.language);
                UpdateDialog.this.updateOkButtonText();
                String cancelText = Updater.TEXTE.get("CANCEL_" + UpdateDialog.this.language.toUpperCase());
                if (cancelText != null) {
                    cancelButton.setText(cancelText);
                }
                UpdateDialog.this.infoLabel.setText(String.valueOf(Updater.TEXTE.get("INFO_" + UpdateDialog.this.language.toUpperCase())) + version);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        SplashScreen sp = SplashScreen.getSplashScreen();
        if (sp != null) {
            sp.close();
        }
        this.toFront();
    }

    protected void updateOkButtonText() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        String number = nf.format((double)this.updateSize / 1024.0);
        String size = "KB";
        if (this.updateSize > 0x100000L) {
            number = nf.format((double)this.updateSize / 1024.0 / 1024.0);
            size = "MB";
        }
        String okText = Updater.TEXTE.get("INSTALL_" + this.language.toUpperCase());
        if ((okText = String.valueOf(okText) + " (" + number + " " + size + ")") != null) {
            this.installButton.setText(okText);
        }
    }

    protected void update(String[] args) {
        DownloadDialog downloadDialog = new DownloadDialog(this, this.language, args);
        downloadDialog.setVisible(true);
    }

    private void centerDialog() {
        Point location;
        Dimension size;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.getOwner() == null) {
            size = tk.getScreenSize();
            location = new Point(0, 0);
        } else {
            size = this.getOwner().getSize();
            location = this.getOwner().getLocation();
        }
        this.setLocation((size.width - this.getWidth()) / 2 + location.x, (size.height - this.getHeight()) / 2 + location.y);
    }

    private long getFileSize() throws IOException {
        long result = 0L;
        List<String> fileList = Updater.getFileList();
        for (String fileString : fileList) {
            File file = new File(Updater.getProgramFolder(), fileString);
            String checksum = Updater.getChecksum(file);
            String checksum2 = Updater.getFileData(String.valueOf(fileString) + ".checksum");
            if (checksum != null && checksum.equals(checksum2)) continue;
            result += Updater.getSize(fileString);
        }
        return result;
    }
}

