/*
 * Decompiled with CFR 0.152.
 */
package de.skatcom.skatupdater;

import de.skatcom.skatupdater.Updater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class DownloadDialog
extends JDialog {
    private static final long serialVersionUID = -8444578091823834202L;
    private final JPanel contentPanel = new JPanel();
    private Thread workingThread;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private boolean cancel = false;

    public DownloadDialog(final JFrame parent, final String lang, final String[] args) {
        super(parent);
        this.setModal(true);
        this.setTitle("Download Update");
        this.setSize(450, 125);
        this.centerDialog();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.contentPanel.add((Component)this.progressBar, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.cancelButton = new JButton(Updater.TEXTE.get("CANCEL_" + lang));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DownloadDialog.this.cancel = true;
            }
        });
        buttonPane.add(this.cancelButton);
        this.workingThread = new Thread(){
            File workingFolder;
            List<String> fileList;
            List<File> updateList = new ArrayList<File>();

            @Override
            public void run() {
                boolean tryAgain = true;
                while (tryAgain) {
                    try {
                        this.init();
                        this.download();
                        this.install();
                        this.cleanup();
                        this.startProg(args);
                        tryAgain = false;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        int ant = JOptionPane.showConfirmDialog(parent, String.valueOf(Updater.TEXTE.get("ERROR_" + lang)) + "\n\n" + Updater.getStackTrace(e), Updater.TEXTE.get("ERRTITLE_" + lang), 0);
                        if (ant != 1) continue;
                        System.exit(-1);
                    }
                }
            }

            private void cleanup() throws IOException {
                Updater.cleanTempFolder();
            }

            private void startProg(String[] args2) throws IOException {
                DownloadDialog.this.updateProgressBar(100, "Update abgeschlossen!");
                DownloadDialog.this.setVisible(false);
                DownloadDialog.this.dispose();
                parent.setVisible(false);
                parent.dispose();
                Updater.runProgram(args2);
            }

            private void init() throws IOException {
                DownloadDialog.this.updateProgressBar(0, "Initialisiere Download");
                this.workingFolder = Updater.getTempFolder();
                if (DownloadDialog.this.cancel) {
                    DownloadDialog.this.abort();
                }
                DownloadDialog.this.updateProgressBar(5, "Ermittle Download-Umfang");
                this.fileList = Updater.getFileList();
                for (String fileString : this.fileList) {
                    File file = new File(Updater.getProgramFolder(), fileString);
                    String checksum = Updater.getChecksum(file);
                    String checksum2 = Updater.getFileData(String.valueOf(fileString) + ".checksum");
                    if (checksum == null || !checksum.equals(checksum2)) {
                        this.updateList.add(file);
                    }
                    if (!DownloadDialog.this.cancel) continue;
                    DownloadDialog.this.abort();
                }
            }

            private void download() throws IOException {
                if (DownloadDialog.this.cancel) {
                    DownloadDialog.this.abort();
                }
                if (this.updateList.size() == 0) {
                    return;
                }
                int inc = 60 / this.updateList.size();
                int value = 10;
                for (File file : this.updateList) {
                    if (DownloadDialog.this.cancel) {
                        DownloadDialog.this.abort();
                    }
                    DownloadDialog.this.updateProgressBar(value, "Lade herunter: " + file.getName());
                    Updater.downloadFile(file.getName(), this.workingFolder);
                    value += inc;
                }
            }

            private void install() throws IOException {
                if (DownloadDialog.this.cancel) {
                    DownloadDialog.this.abort();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadDialog.this.cancelButton.setEnabled(false);
                    }
                });
                int value = 70;
                int inc = this.updateList.size() / 30;
                for (File file : this.updateList) {
                    DownloadDialog.this.updateProgressBar(value, "Installiere: " + file.getName());
                    Updater.copyFile(file.getName(), this.workingFolder);
                    value += inc;
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(Updater.getProgramFolder(), "version")));
                bw.write(Updater.getLatestVersion());
                bw.close();
            }
        };
        this.workingThread.start();
    }

    private void abort() {
        System.exit(-1);
    }

    private void updateProgressBar(final int value, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadDialog.this.progressBar.setString(text);
                DownloadDialog.this.progressBar.setValue(value);
            }
        });
    }

    private void centerDialog() {
        Point location;
        Dimension size;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.getOwner() == null) {
            size = tk.getScreenSize();
            location = new Point(0, 0);
        } else {
            size = this.getOwner().getSize();
            location = this.getOwner().getLocation();
        }
        this.setLocation((size.width - this.getWidth()) / 2 + location.x, (size.height - this.getHeight()) / 2 + location.y);
    }
}

